//Listing 16.6. Przykady wykorzystania konstruktorw konwertujcych oraz operatorw konwersji.
#include <iostream>
using namespace std;

class String {
  int size; // rozmiar acucha
  char *str; // pocztek acucha wewntrznego
  void set(const char* s); // przydzia acucha prywatnego
public:
  String (const char* s = "") // konstruktor konwertujcy oraz domylny
    { set(s); }
  String (const String &s) // konstruktor kopiujcy
    { set(s.str); }
  ~String() // destruktor
    { delete [ ] str; }
  String& operator = (const String& s); // przypisanie
  operator int() const; // biecy rozmiar acucha
  operator char* () const; // wskanik na pocztek
} ;

void String::set(const char* s)
{ size = strlen(s); // oblicz rozmiar
  str = new char[size + 1]; // zadaj pamici na stercie
  if (str == 0) { cout << "Brak pamici\n"; exit(0); }
  strcpy(str,s); } // skopiuj dane klienta na stert

String& String::operator = (const String& s)
{ if (this == &s) return *this; // nie wykonuj nic gdy przypisanie do tego samego obiekt
  delete [ ] str; // zwr istniejc pami
  set(s.str); // przydziel (ustaw) nowy obszar pamici
  return *this; } // w celu obsugi przypisywania w acuchu

String::operator int() const // brak zmian dla obiektu String
{ return size; }

String::operator char* () const // obiekt nie zostaje zmieniony
{ return str; } // wskanik na pocztek

class Account { // klasa bazowa hierarchii
protected:
  double balance; // dane chronione
  char *owner;
public:

  Account(const char* name, double initBalance) // konstruktor oglny
  { owner = new char[strlen(name)+1]; // przydziel pami na stercie
    if (owner == 0) { cout << "\nBrak pamici\n"; exit(0); }
      strcpy(owner, name); // zainicjalizuj pola danych
      balance = initBalance; }

  Account(const String& s)
  { int len = s; // pobierz rozmiar acucha
    owner = new char[len+1]; // przydziel pami na stercie
    if (owner == 0) { cout << "\nBrak pamici\n"; exit(0); }
    strcpy(owner, s); // zainicjalizuj pola danych
    balance = 0; }

  operator double () const // obiekt nie zostaje zmieniony
  { return balance; }

  operator String () const // utwrz obikt klasy String
  { return owner; } // konwersja niejawna

  void operator -= (double amount)
  { balance -= amount; } // przeka odwpowiedzialno wyej

  void operator += (double amount)
  { balance += amount; } // zwiksz warto bezwarunkowo
} ;

int main()
{
  String owner("Kowalski"); // konstruktor konwertujcy
  Account a(owner); // konstruktor konwertujcy
  a += 500; a -=200; a += 400; // operatory przecione
  String s = a; // obsu jako warto typu String
  double limit = 2 * a; // obsu jako warto typu double
  cout << "Nazwisko: " << (char *)s << endl; // jawna konwersja
  cout << "Stan konta: " <<(double)a <<endl; // jawna konwersja
  cout << "Limit kredytowy: " << limit << endl;
  return 0;
}
